# -*- coding: utf-8 -*-

import sandbox.sandboxsdk.environments as sdk_environments
from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp


class YabsDataPrepareBrands(sdk2.Task):
    '''Fetch Brands data from External sources'''

    class Requirements(sdk2.Requirements):
        disk_space = 4 * 1024

        environments = [
            sdk_environments.PipEnvironment('yandex-yt'),
            sdk_environments.PipEnvironment("yandex-yt-yson-bindings-skynet"),
        ]

    class Parameters(sdk2.Task.Parameters):
        yt_proxies = sdk2.parameters.String('yt_proxies', default='hahn banach', required=True)
        destination_path = sdk2.parameters.String(
            'Destination cypress path',
            default='//tmp/dzap/cached_brands/',
            required=True)

    def on_execute(self):
        from . import import_launcher

        token = sdk2.Vault.data('prepare_data_yt_token')
        proxies = self.Parameters.yt_proxies.split()

        for proxy in proxies:
            with sdk2.helpers.ProcessLog(self, logger="cbr_import_" + proxy) as log:
                log.logger.propagate = 1
                import_launcher.run(sp, log, token, proxy, self.Parameters.destination_path)
