import logging
import socket

import yt.wrapper as yt

import json

CBR_SOURCE = '//home/extdata/aurora/other/serp/mfo'


def map_cbr_table(row):
    value = json.loads(row['value'])
    yield {
        'source': 'cbr.ru',
        'url': value['url'],
        'name': value['full_name']
    }


class CbrImporter:
    def __init__(self, dest_path):
        self._res_table = dest_path + 'cbr'

    def run_import(self):
        logging.info('Starting Cbr import\nCbrSource:{}\nCbrDest:{}'.format(CBR_SOURCE, self._res_table))

        with yt.Transaction(attributes={'host': socket.getfqdn()}):
            yt.create('table', path=self._res_table, recursive=True, ignore_existing=True, attributes=None)
            yt.run_map(map_cbr_table, yt.TablePath(CBR_SOURCE, columns=['value']),
                       self._res_table, sync=True)

        logging.info('Cbr import Operation is finished. You can find the result there: ' + self._res_table)
