#!/usr/bin/env python

import argparse
import json
import logging
import os
import sys

import yt.wrapper as yt

from cbr_importer import CbrImporter


def run(sp, log, yt_token, yt_proxy, dest_path):
    env = os.environ.copy()
    env["YT_PROXY"] = '{}.yt.yandex.net'.format(yt_proxy)
    env["YT_TOKEN"] = yt_token

    sp.Popen(['/skynet/python/bin/python',
              os.path.join(os.path.dirname(__file__), "import_launcher.py"),
              '--dest-path', dest_path,
              ], stdout=log.stdout, stderr=sp.STDOUT, env=env).wait()


def main(args):
    logging.info("Run importer with the following arguments: " + json.dumps(vars(args)))

    importer = CbrImporter(args.dest_path)
    importer.run_import()
    pass


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument('--dest-path', required=True)
    args = parser.parse_args(sys.argv[1:])

    logging.basicConfig(level=logging.DEBUG, format="%(asctime)s %(levelname)s (%(module)s) %(message)s")

    yt.update_config({'pickling': {'python_binary': '/skynet/python/bin/python'}})

    main(args)
