# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.task import SandboxTask
import sandbox.common.types.client as ctc
import tarfile

from sandbox.projects.common.yabs.yabs_ab_info import YabsABInfo


class YabsDownloadABInfo(SandboxTask):
    type = 'YABS_DOWNLOAD_AB_INFO'
    input_parameters = ()

    client_tags = ctc.Tag.LINUX_PRECISE
    cores = 1

    def on_execute(self):
        TAR_FILE = "ab_info.tgz"
        files = YabsABInfo.download()
        with tarfile.open(TAR_FILE, mode="w:gz") as tar:
            for f in files:
                tar.add(f)

        self.create_resource(description="Yabs AB Info",
                             resource_path=TAR_FILE,
                             resource_type=YabsABInfo.RESOURCE_TYPE)


__Task__ = YabsDownloadABInfo
