# -*- coding: utf-8 -*-

import tarfile
import sandbox.common.types.client as ctc
from sandbox.sandboxsdk import environments
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.projects.common.yabs.app_options import AppOptions, APP_OPTIONS_YT_PROXY, APP_OPTIONS_YT_DIR


TAR_FILE = 'host_options.tgz'
VAULT_USER = 'ADVQUALITY'
ROBOT_TOKEN = 'yt-token-bs-startrek'


class YabsDownloadHostOptions(SandboxTask):
    type = 'YABS_DOWNLOAD_HOST_OPTIONS'
    input_parameters = ()

    client_tags = ctc.Tag.LINUX_PRECISE
    cores = 1
    environment = (environments.PipEnvironment('yandex-yt'),)

    def on_execute(self):
        from yt.wrapper import YtClient

        files = AppOptions.download()
        token = self.get_vault_data(VAULT_USER, ROBOT_TOKEN)
        yt_client = YtClient(proxy=APP_OPTIONS_YT_PROXY, token=token)

        with yt_client.Transaction():
            yt_client.create("map_node", APP_OPTIONS_YT_DIR, recursive=True, ignore_existing=True)
            with tarfile.open(TAR_FILE, mode='w:gz') as tar:
                for f in files:
                    tar.add(f)
                    yt_client.smart_upload_file(f, "/".join([APP_OPTIONS_YT_DIR, f]), placement_strategy='replace')

        self.create_resource(description='Yabs Application Options',
                             resource_path=TAR_FILE,
                             resource_type=AppOptions.RESOURCE_TYPE)


__Task__ = YabsDownloadHostOptions
