# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.task import SandboxTask
import sandbox.common.types.client as ctc
import tarfile

from sandbox.projects.common.yabs.yabs_sharded_timestats4 import YabsShardedTimestats4

TAR_FILE = "sharded_timestats4.tgz"


class YabsDownloadShardedTimestats4(SandboxTask):
    type = 'YABS_DOWNLOAD_SHARDED_TIMESTATS4'
    input_parameters = ()

    client_tags = ctc.Tag.LINUX_PRECISE
    cores = 1

    def on_execute(self):
        files = YabsShardedTimestats4.download()
        with tarfile.open(TAR_FILE, mode="w:gz") as tar:
            for f in files:
                tar.add(f)

        self.create_resource(description="Yabs Sharded Timestats4",
                             resource_path=TAR_FILE,
                             resource_type=YabsShardedTimestats4.RESOURCE_TYPE)


__Task__ = YabsDownloadShardedTimestats4
