# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.task import SandboxTask
import sandbox.common.types.client as ctc
import tarfile

from sandbox.projects.common.yabs.yabs_timestats4 import YabsTimestats4

TAR_FILE = "timestats4.tgz"


class YabsDownloadTimestats4(SandboxTask):
    type = 'YABS_DOWNLOAD_TIMESTATS4'
    input_parameters = ()

    client_tags = ctc.Tag.LINUX_PRECISE
    cores = 1

    def on_execute(self):
        files = YabsTimestats4.download()
        with tarfile.open(TAR_FILE, mode="w:gz") as tar:
            for f in files:
                tar.add(f)

        self.create_resource(description="Yabs Timestats4",
                             resource_path=TAR_FILE,
                             resource_type=YabsTimestats4.RESOURCE_TYPE)


__Task__ = YabsDownloadTimestats4
