# -*- coding: utf-8 -*-
from sandbox import sdk2

import ssl  # supress ssl check
ssl.HAS_SNI = False
import datetime
import logging
import json
from sandbox.sandboxsdk.channel import channel
from sandbox.projects.YabsDutyScheduleGenerator import YabsDutySchedule


def _to_str(date):
    return datetime.datetime.strftime(date, "%Y-%m-%d")


class YabsDutyScheduler(sdk2.Task):

    class Requirements(sdk2.Requirements):
        cores = 1  # exactly 1 core
        ram = 1024  # 1GiB or less

        class Caches(sdk2.Requirements.Caches):
            pass  # means that task do not use any shared caches

    class Parameters(sdk2.Task.Parameters):
        response_emails = sdk2.parameters.List('Введите адреса, на которые будет приходить предварительная рассылка', default=['danilgrig@yandex-team.ru'])
        overall_email = sdk2.parameters.List('Введите адрес на который будет приходить массовая рассылка', default=['danilgrig@yandex-team.ru'])
        send_to_users = sdk2.parameters.Bool('Отправлять письма дежурным?', default=False)
        weeks_count = sdk2.parameters.Integer('На сколько недель сгенерировать письмо?', default=3)
        weeks_shift = sdk2.parameters.Integer('За какую неделю вперед сгенерировать письмо?', default=1)
        create_resources_with_duty = sdk2.parameters.Bool('Генерация ресурса с дежурными для релизной машины', default=False)

    def on_execute(self):
        from . import worker
        token = sdk2.Vault.data("YABS-YTSTAT", "yabs_duty_token")
        response_emails = self.Parameters.response_emails
        overall_email = self.Parameters.overall_email
        weeks_count = self.Parameters.weeks_count
        weeks_shift = self.Parameters.weeks_shift

        first_day_title = None
        last_day_title = None
        weeks = []
        weeks_str = []
        for i in range(weeks_count):
            first_day, last_day = worker.get_week_first_last_day(
                datetime.datetime.now() + datetime.timedelta(days=7 * (weeks_shift + i))
            )

            first_day_str = _to_str(first_day)
            if not first_day_title:
                first_day_title = first_day_str
            last_day_str = _to_str(last_day)
            last_day_title = last_day_str

            week_str = (first_day_str, last_day_str)
            logging.info("Looking data from {} to {}".format(*week_str))
            week = worker.fetch_week_row(first_day_str, token)
            logging.info(week)

            weeks.append(week)
            weeks_str.append(week_str)

        email_text_all = worker.format_overall_mail(weeks, weeks_str, "", False)
        email_text_resp = worker.format_overall_mail(weeks, weeks_str, "", True)

        logging.info("Will send email to {}".format(','.join(response_emails)))
        email_header = worker.SOURCE_TITLE_TEMPLATE.format(first_day_title, last_day_title)

        # worker.send_mail(response_emails, email_header, email_text_resp, email_text_resp, email_header)
        # mail_to, mail_cc, mail_subject, mail_body, content_type='text/plain', charset='utf-8', extra_headers=None, urgent=False, owner='sandbox'
        if response_emails:
            channel.sandbox.send_email(','.join(response_emails), '', email_header, email_text_resp, 'text/html', 'utf-8')

        send_personal = self.Parameters.send_to_users
        persons = worker.get_response_persons(weeks[0])
        logging.info("Candidate persons for mail to responses {}".format(','.join(persons)))
        if send_personal:
            # worker.send_mail(overall_email, email_header, email_text_all, email_text_all, email_header)
            channel.sandbox.send_email(overall_email, '', email_header, email_text_all, 'text/html', 'utf-8')
            # worker.send_mail(persons, email_header, email_text_all, email_text_all, email_header)
            channel.sandbox.send_email(','.join(persons), '', email_header, email_text_all, 'text/html', 'utf-8')

        if self.Parameters.create_resources_with_duty:
            self.create_resources_with_duty(first_day_title, weeks[0])

    def create_resources_with_duty(self, first_day, cur_week):
        duty_data = {"Week": first_day}
        # create the format like script's output
        for key, value in cur_week.iteritems():
            if len(value) == 2:
                for i in range(2):
                    duty_data["*{}{}".format(key, i + 1)] = value[i].values()[0]
            else:
                duty_data[key] = value[0].values()[0]  # KILLME
        week_data_path = "{}.json".format(first_day)
        with open(week_data_path, 'w') as week_data_file:
            json.dump(duty_data, week_data_file, indent=4)
            YabsDutySchedule(self, 'Timetable of duty', week_data_path, ttl=42, week=first_day)
