# -*- coding: utf-8 -*-
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText
from email.header import Header
import re
import smtplib
import datetime
import requests
import json


ignore_emails = ['admin', 'bambino', 'auto', 'none', 'null', 'nil', '']
DUTY_PAGE_API = 'https://wiki-api.yandex-team.ru/_api/frontend/BannernajaKrutilka/duty/DutyPlan/.grid?fromat=json'
DUTY_PAGE = 'https://wiki.yandex-team.ru/BannernajaKrutilka/duty/DutyPlan/'
MAIN_DUTY_PAGE = 'https://wiki.yandex-team.ru/BannernajaKrutilka/duty/'
FAQ_DUTY_PAGE = 'https://wiki.yandex-team.ru/bannernajakrutilka/duty/faq-bs-duty/'

SOURCE_TITLE_TEMPLATE = 'Расписание дежурств БК с {} по {} <yabs-scheduler@yandex-team.ru>'
RESPONSE_DUTY_URL = ''


class SendException(Exception):
    pass


def validate_list(src, ignore_list=['']):
    dst_list = src
    if isinstance(src, (str, unicode)):
        dst_list = re.split(r'[\s,;]+', src.strip())
    elif not isinstance(src, list):
        raise SendException('Can`t validate list: Wrong type of field')
    return list(set(dst_list) - set(ignore_list))


def validate_recipients_list(emails_list):
    out_list = []
    for email in validate_list(emails_list):
        if type(email) not in (str, unicode):
            raise SendException('Can`t validate list: Wrong type of field')
        if email.split('@')[0] in ignore_emails:
            continue
        if '@' in email:
            out_list.append(email)
        else:
            out_list.append(email+'@yandex-team.ru')
    return list(set(out_list))


def send_mail(to, subject, body_txt, body_html, frm=SOURCE_TITLE_TEMPLATE):
    to = validate_recipients_list(to)
    if len(to) == 0:
        return
    msg = MIMEMultipart('alternative')
    msg.set_charset('utf8')
    msg['From'] = frm
    msg['To'] = ', '.join(to)
    msg['Subject'] = Header(subject, 'UTF-8').encode()
    if body_txt:
        body = MIMEText(body_txt, 'plain', 'utf8')
        msg.attach(body)
    if body_html:
        header = "<!doctype html>\n<meta charset=UTF-8>\n<body style=font-family:sans-serif>\n"
        footer = "\n</body>"
        body = MIMEText(header + body_html + footer, 'html', 'utf8')
        msg.attach(body)
    try:
        srv = smtplib.SMTP('localhost')
        srv.sendmail(frm, to, msg.as_string())
        srv.quit()
    except smtplib.SMTPException:
        raise SendException('No e-mails was sent. Internal SMTP exception occured')


def should_make_week_shift(date):
    return datetime.datetime(date.year, 1, 1).isocalendar()[1] != 1


def get_week_first_last_day(date):
    year = date.year
    week_num = date.isocalendar()[1]
    if should_make_week_shift(date):
        week_num += 1

    first_day = datetime.datetime.strptime("{Y}-{W}-{D}".format(Y=year, W=week_num, D=1), "%Y-%W-%w")
    last_day = datetime.datetime.strptime("{Y}-{W}-{D}".format(Y=year, W=week_num, D=0), "%Y-%W-%w")
    return first_day, last_day


def fetch_week_row(date, token):
    """
    Dict struct:
    "tour":
       [{"day":[people, people]}, {"day":[people, people]}]
    """
    headers = {'Authorization': 'OAuth ' + token}
    r = requests.get(DUTY_PAGE_API, headers=headers, verify=False)
    rows = r.json()['data']['rows']
    cols = [col['title'] for col in r.json()['data']['structure']['fields']]
    result = {}
    week_row = []
    print json.dumps(r.json()['data'], indent=4, sort_keys=True)
    for row in reversed(rows):
        for i in xrange(len(row)):
            if row[i]['raw'] == date:
                week_row = row
                break
        if week_row:
            break
    for num, cell in enumerate(week_row):
        tour_name = _get_tour_name(cols[num])
        if isinstance(cell['raw'], list) and cell['raw']:
            if tour_name not in result:
                result[tour_name] = []
            if len(cell['raw']) > 1:
                if cols[num].endswith("1"):
                    result[tour_name].append({"пн": [cell["raw"][i] for i in xrange(len(cell["raw"]))]})
                elif cols[num].endswith("2"):
                    result[tour_name].append({"чт": [cell["raw"][i] for i in xrange(len(cell["raw"]))]})
                else:
                    result[tour_name].append({"пн": [cell["raw"][i] for i in xrange(len(cell["raw"]))]})
            else:
                if not result[tour_name]:
                    result[tour_name].append({"пн": [None] * 2})
                if cols[num].endswith("2"):
                    result[tour_name][0]["пн"][1] = cell["raw"][0]
                else:
                    result[tour_name][0]["пн"][0] = cell["raw"][0]
    return result


def get_response_persons(data):
    result = set([])
    for tour in data:
        for day in data[tour]:
            for people in day.values():
                for man in people:
                    if man:
                        result.add(man)
    return list(result)


def _get_people_tour_hash(week):
    checker = {}
    for tour, days_array in week.iteritems():
        for day in days_array:
            for num, people in enumerate([p for p in day.values()[0] if p is not None]):  # always one record
                if people not in checker:
                    checker[people] = set([])
                checker[people].add((tour, num))
    return checker


def _check_cur_week(week):
    checker = _get_people_tour_hash(week)
    result = ""
    for people, tours in checker.iteritems():
        if len(tours) > 1:
            first = next(iter(tours))
            if not any(num[1] != first[1] for num in tours):
                result += people + " дежурит сразу за {}<br>".format(','.join((str(t[0]) for t in tours)))
    return result


def _check_duty_on_prev_week(prev_week, cur_week):
    prev_week_check = _get_people_tour_hash(prev_week)
    cur_week_check = _get_people_tour_hash(cur_week)
    intersection = prev_week_check.viewkeys() & cur_week_check.viewkeys()
    result = ""
    for people in intersection:
        prev_duties = list(prev_week_check[people])
        cur_duties = list(cur_week_check[people])
        if len(prev_duties) == len(cur_duties) and prev_duties[0][0] != cur_duties[0][0]:
            result += "{} дежурил на прошлой неделе за {}, а на этой за {}<br>".format(people, prev_duties, cur_duties)
    return result


def get_errors(prev_week, cur_week):
    cur_week_errors = _check_cur_week(cur_week)
    inter_week_errors = _check_duty_on_prev_week(prev_week, cur_week)
    result = ""
    if cur_week_errors:
        result += "Дежурят сразу за 2 дежурства: <br>" + cur_week_errors
    else:
        result += "Сразу за два дежурства никто не дежурит<br>"

    if inter_week_errors:
        result += "Дежурят вторую неделю подряд: <br>" + inter_week_errors
    else:
        result += "Две недели подряд никто не дежурит<br>"

    return result


def _get_tour_name(tour):
    if tour[-1].isdigit():
        tour = tour[:-1]
    if tour[0] == '*':
        tour = tour[1:]
    return tour


def join_weeks(weeks_data):
    joined_weeks = dict()
    all_tours = set()
    for w in weeks_data:
        all_tours = all_tours.union(w.keys())
    for w in weeks_data:
        for tour in all_tours:
            if tour not in w:
                w[tour] = []
    for tour in all_tours:
        tour_week = list()
        for w in weeks_data:
            tour_week.append(w[tour])
        joined_weeks[tour] = tour_week
    return joined_weeks


def format_overall_mail(weeks_data, weeks_str, error_text="", resp_addr=False):
    joined_data = join_weeks(weeks_data)
    text = list()
    text.append("<H3>Привет! Расписание дежурств на три недели:</H3>")
    text.append(
        "<table border='1' cellpadding='10' "
        "style='border-collapse: collapse; border: 2px solid orange;width:70%'>"
        "<tr><td></td>"
    )
    for ws in weeks_str:
        text.append(
            "<td align='center'>{}<br>|<br>{}</td>".format(ws[0], ws[1])
        )
    text.append("</tr>")
    for tour in joined_data:
        text.append("<tr><td><strong>{}</strong></td>".format(tour))
        for w in joined_data[tour]:
            text.append("<td>")
            for day in w:
                for day_name, people in day.iteritems():
                    text.append(
                        "{}:{}<br>".format(
                            day_name,
                            ",".join([str(man) for man in people if man])
                        )
                    )
            text.append("</td>")
        text.append("</tr>")
    text.append("</table>")

    if resp_addr:
        text.append("<br>Если расписание составлено неверно, его можно исправить по ссылке: {}".format(DUTY_PAGE))
        text.append(error_text)

    text.append("<br>FAQ по дежурствам: {}".format(FAQ_DUTY_PAGE))
    text.append("<br>Информацию о планировании дежурств можно посмотреть здесь: {}".format(MAIN_DUTY_PAGE))

    return "".join(text)
