from sandbox.projects.common.yabs.performance_best_cmp.stats import hodges_lehmann_median
from sandbox.projects.yabs.qa.performance.compare import compare_rps
from sandbox.projects.yabs.qa.performance.collect import RpsResults
from sandbox.projects.yabs.qa.utils.resource import sync_resource
from sandbox import sdk2


class SubtasksAggregatorParameters(sdk2.Task.Parameters):
    rps_diff_percent_threshold = sdk2.parameters.Integer('Rps diff percent threshold', required=True)


class SubtasksAggregator:
    def __init__(self, parameters):
        self._parameters = parameters

    @staticmethod
    def get_init_parameters_class():
        return SubtasksAggregatorParameters

    def get_merged_results(self, subtasks_data):
        from sandbox.projects.yabs.qa.task_factory.perf_shoot_task.proto import generic_perf_result_pb2

        merged_results = [[], []]
        for subtask_id, shuffled_parameters in subtasks_data:
            subtask_results = generic_perf_result_pb2.TGenericPerfResultList()

            subtask_results_path = sync_resource(sdk2.Task[subtask_id].Parameters.results_resource)
            with open(subtask_results_path, 'rb') as f:
                subtask_results.ParseFromString(f.read())

            for shoot_result in subtask_results.PerfResultList:
                run_index = shoot_result.RunIndex - 1
                if shuffled_parameters:
                    run_index ^= 1

                stats = shoot_result.Stats
                merged_results[run_index].append(stats.AvgRps)
        return merged_results

    def get_diff_results(self, subtasks_data):
        merged_results = self.get_merged_results(subtasks_data)
        rps_results = []
        for results in merged_results:
            rps_list = sorted(results, reverse=True)
            rps_hl_median = hodges_lehmann_median(rps_list)
            rps_results.append(RpsResults(0, rps_hl_median, rps_list))

        diff = compare_rps(*rps_results)
        has_diff = abs(diff.diff_percent) > self._parameters.rps_diff_percent_threshold
        return diff, has_diff

    def make_report(self, subtasks_data):
        diff, has_diff = self.get_diff_results(subtasks_data)
        report = 'Hodges-Lehmann median of rps change from {0.pre_hl_median:.2f} to {0.test_hl_median:.2f} by {0.diff_percent:+.2f}%'.format(diff)
        return report, has_diff
