from sandbox import sdk2

from sandbox.projects.YabsLmService.modules.shoot_session_aggregator.adapters.sandbox.parameters import SessionAggregatorParameters
from sandbox.projects.YabsLmService.modules.shoot_session_aggregator.adapters.interface import SessionAggregatorAdapterInterface
from sandbox.projects.YabsLmService.modules.shoot_session_aggregator import SessionAggregator

from sandbox.projects.yabs.qa.dumper_module.adapters.sandbox import DumperModuleSandboxAdapter
from sandbox.projects.yabs.qa.adapter_base.sandbox import SandboxAdapterBase


class SessionAggregatorSandboxAdapter(SessionAggregatorAdapterInterface, SandboxAdapterBase):
    def __init__(self, parameters, task_instance, dump_resource_class):
        from sandbox.projects.yabs.qa.task_factory.perf_shoot_task.proto import generic_perf_result_pb2

        SandboxAdapterBase.__init__(self, parameters, task_instance)
        self.dumper_module = DumperModuleSandboxAdapter(parameters, task_instance).create_module()
        self.dump_resource_class = dump_resource_class
        self._task_instance = task_instance

        self.results = generic_perf_result_pb2.TGenericPerfResultList()

    @staticmethod
    def get_init_parameters_class():
        return SessionAggregatorParameters

    def feed_dump(self, dump_path, index):
        result = self.results.PerfResultList.add()
        result.RunIndex = index

        stats = self.dumper_module.get_processed_stats(dump_path, add_raw_stats=True)
        result.Stats.AvgRps = float(stats['rps'])

    def upload_results(self):
        dump_resource = self.dump_resource_class(
            self._task_instance,
            'Generic perf results resource',
            'generic_perf_results.txt',
        )
        stats_resource_data = sdk2.ResourceData(dump_resource)
        stats_resource_data.path.write_bytes(self.results.SerializeToString())
        stats_resource_data.ready()

        return dump_resource

    def get_readable_results(self):
        from protobuf_to_dict import protobuf_to_dict

        return protobuf_to_dict(self.results)

    def create_module(self):
        return SessionAggregator(self)
