from sandbox.projects.yabs.qa.module_base import ModuleBase

from sandbox.projects.yabs.qa.sut.components.linear_models import YabsLinearModels


class LmServiceSUT(YabsLinearModels, ModuleBase):
    def __init__(self, adapter):
        ModuleBase.__init__(self, adapter)
        YabsLinearModels.__init__(
            self,
            task=adapter.get_task_instance(),
            binary_path=adapter.get_lmservice_binary_path(),
            data_path=adapter.get_lmservice_data_path(),
            work_dir=adapter.get_work_dir(),
        )

    def __enter__(self):
        YabsLinearModels.__enter__(self)
        return self

    def __exit__(self, *args):
        YabsLinearModels.__exit__(self, *args)

    def flush_state(self):
        YabsLinearModels.flush_state(self)

    def is_active(self):
        return self.process.poll() is None

    def get_port(self):
        return YabsLinearModels.get_port(self)
