from sandbox.projects.YabsLmService.modules.sut.adapters.interface import LmServiceSUTAdapterInterface
from parameters import LmServiceSUTParameters, LmServiceSUTParametersSecondRun
from sandbox.projects.YabsLmService.modules.sut import LmServiceSUT
from sandbox.projects.yabs.qa.adapter_base.sandbox import SandboxAdapterBase

import os


class LmServiceSUTSandboxAdapter(LmServiceSUTAdapterInterface, SandboxAdapterBase):
    def __init__(self, parameters, task_instance, work_dir=None):
        SandboxAdapterBase.__init__(self, parameters, task_instance)
        self._work_dir = work_dir if work_dir else os.getcwd()

    @staticmethod
    def get_init_parameters_class(second_run=False):
        return LmServiceSUTParameters if not second_run else LmServiceSUTParametersSecondRun

    def get_lmservice_binary_path(self):
        return self.sync_resource(self.parameters.lmservice_binary)

    def get_lmservice_data_path(self):
        return self.sync_resource(self.parameters.lmservice_data)

    def get_work_dir(self):
        return self._work_dir

    def create_module(self):
        return LmServiceSUT(self)
