from sandbox import sdk2
from sandbox.projects.YabsLmService.resource_types import YABS_LINEAR_MODELS_EXECUTABLE
from sandbox.projects.websearch.begemot.resources import BEGEMOT_REALTIME_PACKAGE


class LmServiceSUTParameters(sdk2.Task.Parameters):
    with sdk2.parameters.Group("LmService sut parameters:") as sut_group:
        lmservice_binary = sdk2.parameters.Resource('Resource with linear models service binary', resource_type=YABS_LINEAR_MODELS_EXECUTABLE, required=True)
        lmservice_data = sdk2.parameters.Resource('Resource with linear models service data', resource_type=BEGEMOT_REALTIME_PACKAGE, required=True)


class LmServiceSUTParametersSecondRun(sdk2.Task.Parameters):
    with sdk2.parameters.Group("LmService sut parameters for second run:") as sut_group_second_run:
        lmservice_binary_2 = sdk2.parameters.Resource('Resource with linear models service binary', resource_type=YABS_LINEAR_MODELS_EXECUTABLE, required=True)
        lmservice_data_2 = sdk2.parameters.Resource('Resource with linear models service data', resource_type=BEGEMOT_REALTIME_PACKAGE, required=True)
