from sandbox import sdk2
from sandbox.projects.websearch.begemot.resources import BEGEMOT_REALTIME_PACKAGE
from sandbox.projects.yabs.qa.resource_types import BaseBackupAbstractResource
from sandbox.common.types import resource as ctr
from sandbox.sdk2.resource import AbstractResource


class YABS_LINEAR_MODELS_EXECUTABLE(sdk2.Resource):
    releasable = True
    auto_backup = True
    sync_upload_to_mds = True
    releasers = ['YABS_SERVER_SANDBOX_TESTS']
    restart_policy = ctr.RestartPolicy.DELETE
    ttl = 14


class YABS_LINEAR_MODELS_DATA(BEGEMOT_REALTIME_PACKAGE):
    shard = 'YabsRtModels'
    ttl = 14


class YabsLmServicePerformanceResult(AbstractResource):
    restart_policy = ctr.RestartPolicy.DELETE
    auto_backup = True
    sync_upload_to_mds = True
    ttl = 14


class YabsLmServiceDumpParser(BaseBackupAbstractResource):
    """ Resource with dolbilo2json utility """
    releasable = True
    auto_backup = True
    sync_upload_to_mds = True
    ttl = 42
