from sandbox import sdk2
from sandbox.projects.YabsLmService.resource_types import YABS_LINEAR_MODELS_DATA


class YabsLmServiceMarkDataForTestenv(sdk2.Task):
    class Parameters(sdk2.Parameters):
        kill_timeout = 60 * 5
        description = 'Linear models service released data marker'

    def on_execute(self):
        data_resource = sdk2.Resource.find(
            type=YABS_LINEAR_MODELS_DATA,
            attrs={'released': 'stable'}
        ).first()

        data_resource.testenv_switch_trigger_linear_models = self.id

        self.set_info('Marked resource_id: %d' % data_resource.id)
