from sandbox import sdk2

from sandbox.projects.YabsLmService.resource_types import YabsLmServicePerformanceResult

from sandbox.projects.yabs.qa.task_factory.perf_shoot_task import factory as perf_shoot_task_factory
from sandbox.projects.yabs.qa.task_factory.perf_shoot_cmp import factory as perf_cmp_factory

from sandbox.projects.YabsLmService.modules.sut.adapters.sandbox import LmServiceSUTSandboxAdapter
from sandbox.projects.YabsLmService.modules.shoot_session_aggregator.adapters.sandbox import SessionAggregatorSandboxAdapter
from sandbox.projects.YabsLmService.modules.perf_subtasks_aggregator import SubtasksAggregator
from sandbox.projects.yabs.qa.dolbilo_module.simple.adapters.sandbox import DolbiloModuleSandboxAdapter
from sandbox.projects.yabs.qa.ammo_module.requestlog.adapters.general.sandbox import AmmoRequestlogModuleGeneralSandboxAdapter
from sandbox.projects.yabs.base_bin_task import base_bin_task_parameters
from sandbox.common.types.task import ReleaseStatus


def make_perf_shoot_task(is_2on1):
    return perf_shoot_task_factory(
        sut_module_adapter_class=LmServiceSUTSandboxAdapter,
        ammo_module_adapter_class=AmmoRequestlogModuleGeneralSandboxAdapter,
        shoot_module_adapter_class=DolbiloModuleSandboxAdapter,
        session_aggr_module_adapter_class=SessionAggregatorSandboxAdapter,
        dump_resource_class=YabsLmServicePerformanceResult,
        name_postfix='YABS_LMSERVICE',
        is_2on1=is_2on1,
    )


perf_1on1_task = make_perf_shoot_task(is_2on1=False)
perf_2on1_task = make_perf_shoot_task(is_2on1=True)

base_bin_task_bundle_parameters = base_bin_task_parameters(
    release_version_default=ReleaseStatus.STABLE,
    resource_attrs_default={'task_bundle': 'yabs_linear_models_service'},
)


class ShootRequirementsClass(sdk2.Requirements):
    cores = 19
    ram = 64 * 1024
    disk_space = 64 * 1024


class YabsLmServicePerformance1On1(perf_1on1_task):
    Requirements = ShootRequirementsClass

    class Parameters(perf_1on1_task.Parameters):
        kill_timeout = 60 * 30
        _base_bin_task_parameters = base_bin_task_bundle_parameters


class YabsLmServicePerformance2On1(perf_2on1_task):
    Requirements = ShootRequirementsClass

    class Parameters(perf_2on1_task.Parameters):
        kill_timeout = 60 * 40
        _base_bin_task_parameters = base_bin_task_bundle_parameters


class YabsLmServicePerformanceParameters(sdk2.Task):
    class Parameters(perf_2on1_task.SeparateParameters):
        pass


perf_cmp_task = perf_cmp_factory(
    shoot_2on1_task_class=YabsLmServicePerformance2On1,
    subtasks_aggregator_class=SubtasksAggregator,
)


class YabsLmServicePerformanceCmp(perf_cmp_task):
    class Parameters(perf_cmp_task.Parameters):
        kill_timeout = 60 * 40
        _base_bin_task_parameters = base_bin_task_bundle_parameters
