# -*- coding: utf-8 -*-

from sandbox import sdk2
import logging
from sandbox.sandboxsdk import environments
import sandbox.common.types.resource as ctr
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.common.types.task import ReleaseStatus


class YABS_NAV_SEARCH_QUERY_BINARY(sdk2.Resource):
    """ Nav Search Query binary """
    releasable = True
    any_arch = False
    auto_backup = True
    executable = True
    releasers = ['alesap', 'radolga', 'say', 'yabsstartrek']


class YabsNavRegQueriesAggregator(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        yql_cluster = sdk2.parameters.String("Yql and result cluster")
        filter_cluster = sdk2.parameters.String("Filter table cluster")
        yt_token_secret_id = sdk2.parameters.YavSecret(
            label="YT token secret id",
            required=True,
            description='secret should contain keys: YT_TOKEN',
            default="sec-01d4mdr98tm9n1k6a3rmyn685t",
        )
        yql_token_secret_id = sdk2.parameters.YavSecret(
            label="YQL token secret id",
            required=True,
            description='secret should contain keys: yt_token',
            default="sec-01dc7fvj7k3r0h2y81t8dev3ps",
        )
        dest_prefix = sdk2.parameters.String("Destination prefix")
        filter_prefix = sdk2.parameters.String("Filter prefix")

    class Requirements(sdk2.Task.Requirements):
        environments = (
            environments.PipEnvironment('yandex-yt', '0.8.38a1', use_wheel=True),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet', use_wheel=True),
        )
        cores = 1
        ram = 8072
        disk_space = 4096

        class Caches(sdk2.Requirements.Caches):
            pass

    def get_executable(self, yt_token, yt_proxy):
        from yt.wrapper.client import Yt
        ytc = Yt(config={"proxy": {"url": yt_proxy}, "token": yt_token})
        attrs = {
            'released': ReleaseStatus.STABLE,
            'version': ytc.get("//home/yabs/release/prod/YABS_NAV_SEARCH_QUERY_BINARY")
        }

        res = YABS_NAV_SEARCH_QUERY_BINARY.find(state=ctr.State.READY, attrs=attrs).first()
        res_data = sdk2.ResourceData(res)
        return str(res_data.path)

    def on_execute(self):

        yql_token = self.Parameters.yql_token_secret_id.data()["yt_token"]
        yt_token = self.Parameters.yt_token_secret_id.data()["YT_TOKEN"]

        exe_path = self.get_executable(yt_token, self.Parameters.yql_cluster)
        logging.info("Get executable path: {}".format(exe_path))
        command = [
            self.get_executable(yt_token, self.Parameters.yql_cluster),
            '--yql-token',
            yql_token,
            '--yql-host',
            self.Parameters.yql_cluster,
            '--yt-token',
            yt_token,
            '--yt-host',
            self.Parameters.filter_cluster,
            '--dest-prefix',
            self.Parameters.dest_prefix,
            '--filter-prefix',
            self.Parameters.filter_prefix,
        ]
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("YabsNavSearchQueryLogger")) as pl:
            retcode = sp.Popen(command, stdout=pl.stdout, stderr=sp.STDOUT).wait()
            if retcode == 0:
                logging.info("Query processed successfully")
            else:
                raise Exception("YQL query execution failed")
