import argparse
import json
import requests

from yql.api.v1.client import YqlClient


YQL_WEBUI_BASE_URL = 'https://yql.yandex-team.ru/'


def get_public_link(result, token):
    session = requests.Session()
    session.headers.update({
        'User-Agent': 'YQL Sandbox (RUN_YQL task)',
        'Authorization': "OAuth {}".format(token),
        'Content-Type': 'application/json',
    })

    share_id = session.get(
        "{}operations/{}/share_id".format(result.base_url,
                                          result.operation_id)
    )

    return "{}/Operations/{}".format(YQL_WEBUI_BASE_URL,
                                     share_id.json())


def run(db, token, query):
    client = YqlClient(db=db, token=token)
    query = client.query(query)
    query.run()

    if not query.results.is_success:
        raise Exception('\n'.join([str(err) for err in query.results.errors]))

    result = {"result": []}
    for table in query.get_results():
        table.fetch_full_data()

        columns = []
        for column_name, column_type in table.columns:
            columns.append(column_name)

        for row in table.rows:
            result["result"].append(dict([(columns[i], value) for i, value in enumerate(row)]))

    result["public_link"] = get_public_link(query, token)

    return result


def main():
    pars = argparse.ArgumentParser(description="Run yql query")
    pars.add_argument("--query", "-q", help="Query")
    pars.add_argument("--token", "-t", help="Token")
    pars.add_argument("--db", "-d", help="Cluster")
    opts = pars.parse_args()
    return run(opts.db, opts.token, opts.query)


if __name__ == '__main__':
    print(json.dumps(main(), indent=2, sort_keys=True))
