# -*- coding: utf-8 -*-
import sandbox.sandboxsdk.task as sdk_task
from sandbox.sandboxsdk import environments
from sandbox.sandboxsdk import parameters
import os

YT_TOKEN_VAULT_NAME = "robot-yabs-yt-backup-token"

HOST_MAPPING = {
    "hahn": "hahn.yt.yandex.net",
    "seneca-fin": "seneca-fin.yt.yandex.net",
    "seneca-sas": "seneca-sas.yt.yandex.net",
    "alyx": "alyx.yt.yandex.net",
    "barney": "barney.yt.yandex.net"
}


class ClustersTo(parameters.SandboxRadioParameter):
    name = 'cluster_to'
    description = 'Выберите кластер на который поедут данные'
    choices = [(_, _) for _ in HOST_MAPPING]


class TableTo(parameters.SandboxStringParameter):
    name = "table_to"
    description = 'Введите путь в который поедет табличка'


class ClusterFrom(parameters.SandboxRadioParameter):
    name = 'cluster_from'
    description = 'Введите кластер с которого поедут данные'
    choices = [(_, _) for _ in HOST_MAPPING]


class TableFrom(parameters.SandboxStringParameter):
    name = 'table_from'
    description = 'Введите путь таблички которая поедет'


class Task(sdk_task.SandboxTask):
    type = "YABS_WHITE_USERS_TRANSFER"
    environment = (
        environments.PipEnvironment("yandex-yt", use_wheel=True),
        environments.PipEnvironment("yandex-yt-transfer-manager-client", use_wheel=True)
    )

    input_parameters = (
        ClusterFrom,
        TableFrom,
        ClustersTo,
        TableTo,
    )

    def on_execute(self):
        import yt.transfer_manager.client
        import yt.wrapper.client
        from . import worker
        yt_token = self.get_vault_data("ADVQUALITY", YT_TOKEN_VAULT_NAME)
        cluster_from = self.ctx.get("cluster_from")
        table_from = self.ctx.get("table_from")
        cluster_to = self.ctx.get("cluster_to")
        table_to = self.ctx.get("table_to")
        cfg_from = {
            "detached": False,
            "token": yt_token,
            "proxy": {"url": HOST_MAPPING[cluster_from]},
        }
        cfg_to = {
            "detached": False,
            "token": yt_token,
            "proxy": {"url": HOST_MAPPING[cluster_to]}
        }
        yt_from = yt.wrapper.client.Yt(config=cfg_from)
        yt_to = yt.wrapper.client.Yt(config=cfg_to)
        path_from = worker.find_last(yt_from, table_from)
        path_to = os.path.join(table_to, os.path.basename(path_from))
        if worker.create_path(yt_to, path_to):
            worker.clear_old(yt_to, path_to)
            client = yt.transfer_manager.client.TransferManager(token=yt_token)
            client.add_task(cluster_from, path_from, cluster_to, path_to, sync=True)


__Task__ = Task
