# -*- coding: utf-8 -*-
from yt.transfer_manager.client import TransferManager
from yt.wrapper import YtClient
import os


def find_last(yt_connect, folder_path):
    tables = yt_connect.list(folder_path)
    return os.path.join(folder_path, max(tables))


def create_path(yt_connect, path):
    if not yt_connect.exists(path):
        yt_connect.create(type="table", path=path, recursive=True)
        return True
    else:
        return False


def clear_old(yt_connect, path):
    if yt_connect.exists(path):
        tables = yt_connect.list(path)
        if len(tables) > 1:
            earliest = min(tables)
            yt_connect.remove(os.path.join(path, earliest))


if __name__ == "__main__":
    cfg_from = {
        "proxy": {"url": "hahn.yt.yandex.net"}
    }
    cfg_to = {
        "proxy": {"url": "alyx.yt.yandex.net"}
    }
    yt_from = YtClient(config=cfg_from)
    yt_to = YtClient(config=cfg_to)

    client = TransferManager()
    last = find_last(yt_from, "//home/yabs_antifraud/white-users")
    path = os.path.join("//tmp", os.path.basename(last))
    create_path(yt_to, path)
    id = client.add_task("hahn", last, "alyx", path, sync=True)
