#!/usr/bin/env python
# -*- coding: utf8 -*-

from os.path import join as join_path, realpath, dirname

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.process import run_process
from sandbox.common.types.client import Tag

VAULT_USER = "YABS-YTSTAT"
VAULT_YT_NAME = "robot-yabs-toloka-yt-token"
VAULT_YQL_NAME = "robot-yabs-yql-token"


class Task(SandboxTask):
    privileged = True
    type = "YABS_YQL_CRON_TASKS"

    environment = (
    )
    input_parameters = (
    )

    client_tags = Tag.YABS & (Tag.LINUX_PRECISE | Tag.LINUX_TRUSTY)

    def on_execute(self):
        run_process(
            (
                "sudo apt-get update && "
                "sudo apt-get install yandex-yt-python yandex-yql-python -q0 --assume-yes --force-yes -o Dpkg::Options::='--force-confdef'"
            ),
            shell=True, log_prefix='install_yt_yql'
        )
        script_path = join_path(dirname(realpath(__file__)), 'make_top_urls.py')
        run_process([
            'python',
            script_path,
            '--yql_token={}'.format(self.get_vault_data(VAULT_USER, VAULT_YQL_NAME)),
            '--yt_token={}'.format(self.get_vault_data(VAULT_USER, VAULT_YT_NAME)),
        ], log_prefix='make_top_urls', shell=True)


__Task__ = Task
