# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk import environments
import sandbox.common.types.client as ctc
from sandbox.sandboxsdk import parameters as sbparam

import sandbox.projects.common.yabs.ytstat as ytstat
from sandbox.projects.common.yabs import parameters

from sandbox.sdk2 import yav

LOG_FILE = "coordinator.log"
LOOP_DURATION = 15 * 60
ITER_DURATION = 30


class RunTwoCopies(sbparam.SandboxBoolParameter):
    name = 'run_two_copies'
    description = 'Run 2 tasks for each collector at the same time'
    default_value = True


class YabsYTStatCoordinator(SandboxTask):
    type = 'YABS_YT_STAT_COORDINATOR'
    environment = (
        environments.PipEnvironment("yandex-yt", "0.8.46a1", use_wheel=True),
    )
    input_parameters = list(parameters.CollectorParameters) + [RunTwoCopies]
    client_tags = ctc.Tag.LINUX_PRECISE
    cores = 1

    def on_execute(self):
        # Compatibility with old scheduler
        if "yt_proxy" not in self.ctx:
            self.ctx["yt_proxy"] = self.ctx["yt_proxy_url"]
        ytstat.prepare_log_file(self, LOG_FILE)
        with ytstat.stderr_redirect(LOG_FILE):
            self._do_on_execute()

    def _do_on_execute(self):
        ctx = self.ctx

        yt_token_secret_id = ctx["yt_token_secret_id"]
        yt_proxy = ctx["yt_proxy"]
        released = not ctx["is_development"]

        yt_token = None
        if yt_token_secret_id:
            yt_token = yav.Secret(yt_token_secret_id).data()["YT_TOKEN"]

        ytc = ytstat.get_yt_client(yt_proxy, yt_token)
        ytstat.install_supervisor(self, ytc, released)

        from supervisor import coordinator
        coordinator.execute(ytstat.SbApi(self), yt_proxy, yt_token, ctx["log_path"], ctx["is_development"],
                            run_two_copies=ctx["run_two_copies"])


__Task__ = YabsYTStatCoordinator
