# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk import environments
import sandbox.sandboxsdk.parameters as sbparam
import sandbox.common.types.client as ctc

import sandbox.projects.common.yabs.ytstat as ytstat


LOG_FILE = "cloner.log"


class YtProxy(sbparam.SandboxStringParameter):
    name = "yt_proxy"
    description = name
    required = True


class YtTokenVaultName(sbparam.SandboxStringParameter):
    name = "yt_token_vault_name"
    description = name


class Action(sbparam.SandboxStringParameter):
    name = "action"
    description = name
    required = True
    choices = [
        ("clone", "clone"),
        ("clean", "clean"),
    ]


class GroupName(sbparam.SandboxStringParameter):
    name = "group_name"
    description = "Collector group name"
    required = True


class Tables(sbparam.SandboxStringParameter):
    name = "tables"
    description = "Comma-separated table name list"
    required = True


class YabsYTStatTableCloner(SandboxTask):
    type = 'YABS_YTSTAT_TABLE_CLONER'
    environment = (
        environments.PipEnvironment("yandex-yt", "0.7.34.post0", use_wheel=True),
    )

    input_parameters = (
        YtProxy,
        YtTokenVaultName,
        Action,
        GroupName,
        Tables,
    )

    client_tags = ctc.Tag.LINUX_PRECISE
    cores = 1

    def on_execute(self):
        ytstat.prepare_log_file(self, LOG_FILE)
        with ytstat.stderr_redirect(LOG_FILE):
            self._do_on_execute()

    def _do_on_execute(self):
        ctx = self.ctx
        yt_proxy = ctx["yt_proxy"]
        yt_token_vault_name = ctx["yt_token_vault_name"]
        action = ctx["action"]
        group_name = ctx["group_name"]
        tables = ctx["tables"]

        yt_token = None
        if yt_token_vault_name:
            yt_token = self.get_vault_data("YABS-YTSTAT", yt_token_vault_name)

        ytc = ytstat.get_yt_client(yt_proxy, yt_token)
        ytstat.install_supervisor(self, ytc, released=True)

        from supervisor import cloner
        cloner.execute(yt_proxy, yt_token, action, group_name, tables.split(','))


__Task__ = YabsYTStatTableCloner
