import json
import requests
import time

from sandbox import sdk2
import sandbox.sandboxsdk.environments as environments


class PushLogsDataToSolomon(sdk2.Task):
    """Get data on logs' sizes and push it to solomon"""

    class Parameters(sdk2.Task.Parameters):
        proxy = sdk2.parameters.String("YT proxy for the logs", default="hahn")
        path = sdk2.parameters.String("Path to logs on the selected proxy", default="//logs")
        account = sdk2.parameters.String("Required account of logs", default="logfeller-archive-yabs")

    class Requirements(sdk2.Task.Requirements):
        environments = [
            environments.PipEnvironment('yandex-yt')
        ]
        cores = 1
        ram = 4096
        disk_space = 4096

        class Caches(sdk2.Requirements.Caches):
            pass

    def make_path(self, base, extention):
        return base + '/' + extention

    def on_execute(self):
        import yt.wrapper as yt  # Requirements
        yt_client = yt.YtClient(proxy=self.Parameters.proxy, token=sdk2.Vault.data(self.owner, 'BS_READ_YT_TOKEN'))
        solomon_token = sdk2.Vault.data(self.owner, 'robot-yabsstat-solom-token')
        logs_list = yt.yson.yson_to_json(yt_client.list(self.Parameters.path, absolute=True, attributes=['account']))
        account = self.Parameters.account

        sensors = []
        for log_map in logs_list:
            if not isinstance(log_map, dict):
                continue
            log = log_map['$value'].split('/')[-1]
            if log_map['$attributes']['account'] != account and not log.startswith("bs-"):
                continue
            log_path = log_map['$value']
            tables_paths = yt_client.list(log_path, absolute=True)
            if self.make_path(log_path, 'stream') in tables_paths:
                tables_paths.remove(self.make_path(log_path, 'stream'))
                tables_paths += yt_client.list(self.make_path(log_path, 'stream'), absolute=True)
            for tables_path in tables_paths:
                tables = json.loads(yt_client.list(tables_path, attributes=['compressed_data_size', 'account'], format='json'))
                size = 0
                for table in tables:
                    if table['$attributes']['account'] == account:
                        size += table['$attributes']['compressed_data_size']
                sensors.append({
                    "labels": {"sensor": log, "logfeller_batch":  tables_path.replace(log_path + '/', '').replace('/', '::')},
                    "ts": int(time.time()),
                    "value": size,
                })

        out_data = {
            'sensors': sensors
        }
        headers = {
            'Authorization': 'OAuth %s' % solomon_token
        }
        print(json.dumps(out_data))
        resp = requests.post('https://solomon.yandex.net/api/v2/push?project=yabs_stat&cluster=logfeller&service=data_size', headers=headers, json=out_data)
        resp.raise_for_status()
