# coding: utf-8

import logging
import sandbox.projects.addurl as addurl_resources

from sandbox.sandboxsdk import sandboxapi
from sandbox.sandboxsdk import parameters
from sandbox.projects.addurl.common.base_bin_build import BaseBuildAddurlBins
from sandbox.projects.addurl.common.base_bin_build import AddurlBinaries
from sandbox.projects.addurl.common.base_bin_build import init


class BuildAddurlPackage(BaseBuildAddurlBins):
    '''
    Binaries, configs and scripts for Addurl.
    '''

    type = 'BUILD_ADDURL_PACKAGE'

    class IncludeSvnConfigs(parameters.SandboxBoolParameter):
        name = 'include_svn_configs'
        description = 'configs'
        default_value = True
        group = 'Addurl Files'

    class IncludeSvnFrontend(parameters.SandboxBoolParameter):
        name = 'include_svn_frontend'
        description = 'frontend'
        default_value = True
        group = 'Addurl Files'

    class ReleaseToNanny(parameters.SandboxRadioParameter):
        choices = [(_, _) for _ in ('none', sandboxapi.RELEASE_TESTING)]
        description = "Release to Nanny."
        default_value = 'none'
        name = 'release_to_nanny'
        group = 'After Build Actions'

    TARGET_RESOURCES = (
        addurl_resources.ADDURL_ADDURL,
        addurl_resources.ADDURL_BADURL
    )

    input_parameters, enabled_builds = init(TARGET_RESOURCES, [AddurlBinaries])
    input_parameters = input_parameters + [
                                           IncludeSvnConfigs,
                                           IncludeSvnFrontend,
                                           ReleaseToNanny
                                          ]

    def on_execute(self):
        BaseBuildAddurlBins.on_execute(self)

        if self.ctx['release_to_nanny'] != 'none':

            check_already_released = False

            releaser_task = self.create_subtask(
                task_type='RELEASE_ANY',
                input_parameters={
                    'check_already_released': check_already_released,
                    'release_task_id': self.id,
                    'release_status': self.ctx['release_to_nanny'],
                },
                description="Addurl binaries (task id: {}) auto release. Revision: {}".format(str(self.id), self.ctx.get('arcadia_revision'))
            )
            logging.debug("Subtask {} runned, waiting for it's result.\n\n".format(releaser_task.id))

    def post_build(self, source_dir, output_dir, pack_dir):
        BaseBuildAddurlBins.post_build(self, source_dir, output_dir, pack_dir)

        if self.ctx['include_svn_configs']:
            self._create_svn_resource({
                'robot/addurl/conf': ''
            }, 'svn_configs.tar.gz', addurl_resources.ADDURL_SVN_CONFIGS, source_dir)

        if self.ctx['include_svn_frontend']:
            self._create_svn_resource({'robot/addurl/frontend': ''}, 'frontend.tar.gz', addurl_resources.ADDURL_FRONTEND, source_dir)


__Task__ = BuildAddurlPackage
