# coding: utf-8

from sandbox.sdk2.resource import AbstractResource
from sandbox.projects.resource_types import releasers as resource_releasers

# utility


class ADDURL_SYMBOLS_ARCHIVE(AbstractResource):
    """
        Symbols from addurl binaries
    """
    releasable = True
    executable = False
    any_arch = False
    releasers = resource_releasers.samovar_releasers


class ADDURL_BINARY_BASE(AbstractResource):
    """
        Base class for binary files used in Addurl Project.
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = resource_releasers.samovar_releasers


# SVN checkout

class ADDURL_SVN_CONFIGS(AbstractResource):
    """
        Class for Addurl configs from svn
    """
    releasable = True
    executable = False
    releasers = resource_releasers.samovar_releasers


class ADDURL_FRONTEND(ADDURL_SVN_CONFIGS):
    """
        Class for Addurl frontend from svn
    """
    pass


class ADDURL_EXTERNAL_DATA(ADDURL_SVN_CONFIGS):
    """
        Class for Addurl external data
    """
    releasers = resource_releasers.samovar_releasers

# Addurl binaries (for BUILD_ADDURL_PACKAGE)


class ADDURL_ADDURL(ADDURL_BINARY_BASE):
    arcadia_build_path = 'robot/addurl/main/addurl'


class ADDURL_BADURL(ADDURL_BINARY_BASE):
    arcadia_build_path = 'robot/addurl/badurl/badurl'
