from sandbox.projects.adfox.adfox_ui.deploy.adfox_ui_deploy_task import Secrets, AdfoxUiDeployTask
from argparse import ArgumentParser
import logging
import sys

logging.getLogger().setLevel(logging.DEBUG)
handler = logging.StreamHandler(sys.stdout)
handler.setLevel(logging.DEBUG)
formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
handler.setFormatter(formatter)
logging.getLogger().addHandler(handler)

parser = ArgumentParser(description='Adfox UI deploy crowdtest, autotest')
parser.add_argument('--docker-registry-token', dest='docker_registry_token',
                    help="Docker Registry token", required=True)
parser.add_argument('--stage', dest='stage',
                    help="Stage (preprod/autotest)", required=True)
parser.add_argument('--git-branch', dest='git_branch',
                    help="Git branch", required=True)
parser.add_argument('--autotest-stand-type', dest='autotest_stand_type',
                    help="Autotest stand type (adfox|partner)", required=True)
parser.add_argument('--stage_id', dest='stage ID',
                    help="Stage number", required=False, default='0')
args = parser.parse_args()

secrets = Secrets(
    oauth_qloud_token=args.oauth_qloud_token,
    docker_registry_token=args.docker_registry_token,
)

task = AdfoxUiDeployTask(secrets, args.git_branch, args.stage_id)
task.execute(args.stage)
