#!/bin/bash

if [ -z "$1" ]
then
    echo "No common tag specified!";
    exit;
fi

common_tag="$1"
echo "common_tag=${common_tag}"

if [ -z "$2" ]
then
    echo "No new tag specified!";
    exit;
fi

new_tag="$2"
echo "new_tag=${new_tag}"

if [ -z "$3" ]
then
    echo "No token specified!";
    exit;
fi

token="$3"

if [ -z "$4" ]
then
    echo "No image specified!";
    exit;
fi

image_path="$4"
echo "image_path=${image_path}"

curl -s "https://registry.yandex.net/v2/${image_path}/manifests/${common_tag}" \
 -H 'accept: application/vnd.docker.distribution.manifest.v2+json' -H "Authorization: OAuth ${token}" > manifest.json

curl -s -X PUT "https://registry.yandex.net/v2/${image_path}/manifests/${new_tag}" \
 -H "content-type: application/vnd.docker.distribution.manifest.v2+json" -H "Authorization: OAuth ${token}" \
 -d '@manifest.json'
