# -*- coding: utf-8 -*-

import logging
from sandbox import sdk2
from sandbox.projects.deploy.CreateDeployDockerRelease import CreateDeployDockerRelease
import sandbox.common.types.task as ctt

WAIT_DEPLOY_TIMEOUT = 50 * 60


class AdfoxUiRelease(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        tag = sdk2.parameters.String('release version:', required=True)
        repo_list = sdk2.parameters.String('docker repositories (use ";" as a delimiter):', required=True)
        deploy_stage_name_to_wait = sdk2.parameters.String('Deploy stage name to wait:', required=True)

        with sdk2.parameters.Group("YAV secrets") as yav_secrets:
            oauth_secret = sdk2.parameters.YavSecret(
                'Secret for OAuth',
                default='sec-01djcsd32jjt8cz9ppa3ntpvwn',
                required=True,
            )

    def on_execute(self):
        if not self.Context.release_task:
            logging.info('start_docker_release')
            repos = self.Parameters.repo_list.split(';')
            images = map(lambda repo: repo + ':' + self.Parameters.tag, repos)

            logging.info(images)

            release_task = CreateDeployDockerRelease(
                self,
                description="Child of task {}".format(self.id),
                notifications=self.Parameters.notifications,
                create_sub_task=False,
                __requiremetns__={"tasks_resource": self.Requirements.tasks_resource},
            )
            release_task.Parameters.yp_token_yav_secret = self.Parameters.oauth_secret
            release_task.Parameters.yp_token_yav_secret_key = 'oauth-dctl-yp'
            release_task.Parameters.release_type = 'stable'
            release_task.Parameters.docker_images = images
            release_task.Parameters.wait_deploy_tickets = True
            release_task.Parameters.wait_stages = [self.Parameters.deploy_stage_name_to_wait]
            self.Context.release_task = release_task.save().enqueue().id
            logging.info('wait deploy...')
            raise sdk2.WaitTask(
                [self.Context.release_task],
                ctt.Status.Group.FINISH | ctt.Status.Group.BREAK,
                timeout=WAIT_DEPLOY_TIMEOUT,
                wait_all=False
            )
        task = self.find(id=self.Context.release_task, status=ctt.Status.SUCCESS).limit(1).first()
        if task is None:
            raise Exception("Sub task failed. See task id #%s." % self.Context.release_task)
        logging.info("Done!")
