# -*- coding: utf-8 -*-


class DbConnection:
    def __init__(self, config):
        self.db_conn = None
        self.config = config

    def get_db_conn(self):
        import pymysql
        if self.db_conn is None or not self.db_conn.open:
            self.db_conn = pymysql.connect(**self.config)
        return self.db_conn

    def execute_queries(self, queries):
        cur = self.get_db_conn().cursor()

        for query in queries:
            cur.execute(query)

        self.get_db_conn().commit()

        cur.close()

    def select_for_insert(self, table, where=""):
        db_conn = self.get_db_conn()
        cur = db_conn.cursor()

        query = "SELECT * FROM %s" % table
        if where != "":
            query += " WHERE %s" % where

        cur.execute(query)
        rows = cur.fetchall()
        cur.close()

        if len(rows) == 0:
            return ''

        insert_rows = []
        for row in rows:
            values = [db_conn.escape(str(value)) for value in row]
            insert_rows.append("(%s)" % ",".join(values))

        insert_queue = "INSERT IGNORE INTO %s VALUES %s" % (table, ",".join(insert_rows))

        return insert_queue

    def fetch_all(self, query):
        cur = self.get_db_conn().cursor()
        cur.execute(query)
        return cur.fetchall()
