import logging
import time
from sandbox.projects.partner.utils.arc import Arc
import os


class Deploy:
    def __init__(self, dctl_token, arc_token):
        os.environ["DCTL_YP_TOKEN"] = dctl_token
        self.arcadia = Arc(arc_token)
        return

    def is_ready(self, stage):
        is_ready = True

        logging.debug(self.arcadia.path)

        state = self.arcadia._execute(['%sya' % self.arcadia.path, 'tool', 'dctl', 'status', 'stage', stage])

        logging.debug(state)

        for row in state.split("\n")[3:-2]:
            if (row.split('|')[4]).strip() != 'Ready':
                is_ready = False
        logging.debug('stage: %s; is ready: %s' % (stage, is_ready))
        return is_ready

    def wait_ready(self, stage_list, start_delay=300):
        logging.debug('Start to wait ready status for %s' % stage_list)
        time.sleep(max(start_delay - 60, 0))
        not_ready_list = stage_list
        while len(not_ready_list) > 0:
            time.sleep(60)
            new_not_ready_list = []
            for stage in not_ready_list:
                if not self.is_ready(stage):
                    new_not_ready_list.append(stage)
            not_ready_list = new_not_ready_list
            logging.debug('Not ready list %s:' % not_ready_list)

    def finish(self):
        self.arcadia.finish()
