import boto3


class MdsS3:
    def __init__(self, url, bucket_name, access_key=None, secret_key=None):
        self.url = url
        self.bucket_name = bucket_name
        self.client = boto3.client('s3', endpoint_url=url, aws_access_key_id=access_key,
                                   aws_secret_access_key=secret_key,
                                   use_ssl=False, verify=False)

    def list(self, prefix=''):
        return self.client.list_objects(Bucket=self.bucket_name, Prefix=prefix)

    def download(self, key, f_name):
        self.client.download_file(self.bucket_name, key, f_name)
