import logging
from sandbox.sdk2 import helpers
from sandbox.sdk2.helpers import subprocess as sp


class Process:
    def __init__(self, name=None, task=None):
        self.name = name
        self.task = task
        self.logger = logging.getLogger(name)

    def run(self, command, break_on_fail=True):
        with helpers.ProcessLog(self.task, logger=self.logger) as pl:
            process = sp.Popen(command, shell=True, stdout=pl.stdout, stderr=pl.stdout)
            status_code = process.wait()

            if status_code and break_on_fail:
                raise Exception('Subprocess return non-zero code: ' + str(status_code))

            return status_code

    def set_name(self, name=None):
        self.name = name
        return self
