import tempfile
import shutil
import logging


class ResourceHelper:

    prefix = None
    dir = None

    def __init__(self, prefix=None):
        self.prefix = prefix

    def __enter__(self):
        return self

    @property
    def resource_dir(self):
        if not self.dir:
            self.dir = tempfile.mkdtemp()
        return self.dir

    def extract(self, resource_item):
        from library.python import resource
        resource_key = self.prefix + resource_item
        content = resource.resfs_read(resource_key)
        if not content:
            logging.info('Resource {} not found or empty'.format(resource_key))
            return
        filename = self.resource_dir + '/' + resource_item
        with open(filename, 'w') as fp:
            fp.write(content)
        return filename

    def destroy(self):
        if self.dir:
            shutil.rmtree(self.dir)
            self.dir = None

    def __del__(self):
        self.destroy()

    def __exit__(self, exc_type, exc_value, traceback):
        self.destroy()
