# -*- coding: utf-8 -*-

import json
from os.path import join as join_path, realpath, dirname

from sandbox.sandboxsdk import environments
from sandbox import sdk2
import sandbox.common.types.task as ctt
from sandbox.sandboxsdk.process import run_process
from sandbox.projects.common.juggler import jclient


class AdfoxMergeDailyCountersIntoTotal(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        object = sdk2.parameters.String('database object', required=True)
        keep_daily_days = sdk2.parameters.Integer('keep days in daily counters table', default=30, required=True)
        max_days_to_merge = sdk2.parameters.Integer('max days to merge', default=3, required=True)
        juggler_host = sdk2.parameters.String('juggler host', default=None, required=False)

        with sdk2.parameters.Group("mysql") as db_params:
            mysql_host = sdk2.parameters.String('Database host', default='db2.fin.adfox.ru', required=True)
            mysql_user = sdk2.parameters.String('Database user', default='ro', required=True)
            db_password_vault = sdk2.parameters.String('Vault for password',
                                                       default='ADFOX_HOURLY_UPDATE_COUNTERS_DB_PASS')
            mysql_main_db = sdk2.parameters.String('Main db', default='test', required=True)

    def on_enqueue(self):
        self.Requirements.semaphores = ctt.Semaphores(
            acquires=[
                ctt.Semaphores.Acquire(name='ADFOX_MERGE_DAILY_COUNTERS_INTO_TOTAL_{}'.format(self.Parameters.object),
                                       weight=1, capacity=1)
            ],
        )

    def on_execute(self):
        with environments.VirtualEnvironment() as venv:
            environments.PipEnvironment('pymysql', venv=venv, use_wheel=True, version='0.9.3').prepare()

            script_path = join_path(dirname(realpath(__file__)), 'merge_daily_counters_into_total.py')

            mysql = {
                'host': self.Parameters.mysql_host,
                'user': self.Parameters.mysql_user,
                'password': sdk2.Vault.data('ADFOX', self.Parameters.db_password_vault),
                'db': self.Parameters.mysql_main_db,
            }

            settings = {
                'object': self.Parameters.object,
                'keep_daily_days': self.Parameters.keep_daily_days,
                'max_days_to_merge': self.Parameters.max_days_to_merge,
            }

            run_process([
                venv.executable,
                script_path,
                "--mysql='{}'".format(json.dumps(mysql)),
                "--settings='{}'".format(json.dumps(settings)),
            ], log_prefix='merge_daily_counters_into_total', shell=True)

        if self.Parameters.juggler_host:
            jclient.send_events_to_juggler(
                self.Parameters.juggler_host,
                'merge_daily_counters_into_total_{}'.format(self.Parameters.object),
                'OK',
                'Script has been successfully completed.'
            )
