queries = dict()

queries['banner_place'] = """
        SELECT c.supercampaign_id, b.campaign_id, r.banner_id,
            r.site_id, r.zone_id AS section_id, r.place_id,  SUM(r.impressions) AS impressions_total,
            SUM(r.clicks) AS clicks_total
        FROM merge_report_banner_place_24h AS r
        INNER JOIN adfox.banner b ON b.id = r.banner_id
        INNER JOIN adfox.campaign c ON c.id = b.campaign_id
        WHERE day < '{date_to}' AND r.banner_id in ({ids})
        GROUP BY c.supercampaign_id, b.campaign_id, r.banner_id, r.site_id, r.zone_id, r.place_id
        HAVING impressions_total > 0 OR clicks_total> 0
        """

queries['supercampaign'] = """
        SELECT super_campaign_id AS supercampaign_id,
            SUM(impressions) AS impressions_total,  SUM(clicks) AS clicks_total
        FROM merge_report_super_campaign_24h
        WHERE day < '{date_to}' AND super_campaign_id in ({ids})
        GROUP BY super_campaign_id
        HAVING impressions_total > 0 OR clicks_total> 0
        """

queries['campaign_place'] = """
        SELECT campaign_id, site_id, zone_id AS section_id, place_id,
            SUM(impressions) AS impressions_total,  SUM(clicks) AS clicks_total
        FROM merge_report_campaign_place_24h
        WHERE day < '{date_to}' AND campaign_id in ({ids})
        GROUP BY campaign_id, place_id
        HAVING impressions_total > 0 OR clicks_total> 0
        """

queries['campaign_site'] = """
        SELECT campaign_id, site_id,
            SUM(impressions) AS impressions_total,  SUM(clicks) AS clicks_total
        FROM merge_report_campaign_site_24h
        WHERE day < '{date_to}' AND campaign_id in ({ids})
        GROUP BY campaign_id, site_id
        HAVING impressions_total > 0 OR clicks_total> 0
        """

queries['campaign'] = """
        SELECT campaign_id AS campaign_id,
            SUM(impressions) AS impressions_total,  SUM(clicks) AS clicks_total
        FROM merge_report_campaign_24h
        WHERE day < '{date_to}' AND campaign_id in ({ids})
        GROUP BY campaign_id
        HAVING impressions_total > 0 OR clicks_total> 0
        """

queries['banner'] = """
        SELECT banner_id AS banner_id,
            SUM(impressions) AS impressions_total,  SUM(clicks) AS clicks_total
        FROM merge_report_banner_24h
        WHERE day < '{date_to}' AND banner_id in ({ids})
        GROUP BY banner_id
        HAVING impressions_total > 0 OR clicks_total> 0
        """

queries['campaign_adnetwork_site'] = """
        SELECT campaign_id, site_id, adnetwork_id,
            SUM(impressions) AS impressions_total,  SUM(clicks) AS clicks_total
        FROM merge_report_campaign_site_24h
        WHERE day < '{date_to}' AND campaign_id in ({ids}) AND adnetwork_id != 0
        GROUP BY campaign_id, site_id
        HAVING impressions_total > 0 OR clicks_total> 0
        """

queries['campaign_adnetwork_category'] = """
        SELECT campaign_id, adnetwork_id, category_id,
            SUM(impressions) AS impressions_total,  SUM(clicks) AS clicks_total
        FROM merge_report_campaign_adnetwork_category_24h
        WHERE day < '{date_to}' AND campaign_id in ({ids})
        GROUP BY campaign_id, adnetwork_id, category_id
        HAVING impressions_total > 0 OR clicks_total> 0
        """

queries['offer_owners'] = """
        SELECT GROUP_CONCAT(id) FROM adfox.client WHERE contract_type = 'offer_contract' AND group_id = 2
        """

queries['merge_report_offer_owner'] = """
        SELECT owner_id, SUM(loads) AS loads_total FROM merge_report_offer_owner
        WHERE day < '{date_to}' AND owner_id in ({ids})
        GROUP BY owner_id
        HAVING loads_total > 0
        """

queries['reports_status_hourly'] = """
        SELECT IF(total_count = 720, 1, 0)
        FROM
            (SELECT COUNT(*) AS total_count
            FROM reports_status_hourly
            WHERE date >= date_sub(date(now()), interval {ch_read_back_days} + 30 day)
            AND date < date_sub(date(now()), interval {ch_read_back_days} day)
            AND status = 'complete') AS t

        """
