$script = @@
import yt.yson as yson

OWNER_CRITERIA_KEYS = set('oc{}'.format(i) for i in xrange(64))

def parse_referrer(referrer):
    if not referrer:
        return ""
    pos = referrer.find('?')
    return referrer[:pos] if pos != -1 else referrer

def parse_owner_criteria(rest):
    if not rest:
        return yson.dumps({})
    return yson.dumps({key: yson.loads(value) for key, value in rest.iteritems() if key in OWNER_CRITERIA_KEYS})

def merge_ya_audience_with_dmps(segments, dmps):
    result_dmps = [{'id': int(dmp.dmp_id), 'values': list(dmp.segments)} for dmp in dmps]
    if segments:
        result_dmps.append({'id': 0, 'values': list(segments)})
    return yson.dumps(result_dmps)

def get_page_id(block_id):
    arr = block_id.split('-')
    if len(arr) > 1:
        return int(arr[-2])
    return 0

def get_imp_id(block_id):
    arr = block_id.split('-')
    if len(arr) > 1:
        return int(arr[-1])
    return 0

def to_int(value):
    return 0 if value is None else int(value)

def get_from_yson(str_data, key):
    if str_data is None:
        return False
    try:
        yson_data = yson.loads(str_data)
    except ValueError:
        return False
    return yson_data[key] if key in yson_data else None

def is_from_nanpu(headers):
    return str(get_from_yson(headers, 'x-ya-from-nanpu')) == '1'

def preferable_width(query_args):
    return to_int(get_from_yson(query_args, 'preferable-width'))

def preferable_height(query_args):
    return to_int(get_from_yson(query_args, 'preferable-height'))

@@;

$parse_timestamp = Python2::parse_timestamp(Callable<(String?)->Uint64>, $script);
$parse_referrer = Python2::parse_referrer(Callable<(String?)->String>, $script);
$parse_owner_criteria = Python2::parse_owner_criteria(Callable<(Dict<String,Yson>?)->Yson>, $script);
$merge_ya_audience_with_dmps = Python2::merge_ya_audience_with_dmps(
    Callable<(List<Uint64>, List<Struct<'dmp_id':Uint32?,'segments':List<Uint32>?>>)->Yson>, $script);
$get_page_id = Python2::get_page_id(Callable<(String?)->Uint64>, $script);
$get_imp_id = Python2::get_imp_id(Callable<(String?)->Uint64>, $script);
$is_from_nanpu = Python2::is_from_nanpu(Callable<(Yson?)->Bool>, $script);
$preferable_width = Python2::preferable_width(Callable<(Yson?)->Uint64>, $script);
$preferable_height = Python2::preferable_height(Callable<(Yson?)->Uint64>, $script);
