use {CLUSTER};

DROP TABLE `{OWNER_GROUPS_TABLE}`;
DROP TABLE `{SAMPLES_TABLE}`;
DROP TABLE `{DMP_TABLE}`;
COMMIT;

INSERT INTO `{OWNER_GROUPS_TABLE}`
SELECT owner_id, count, RandomNumber(count) % count as group_id FROM
(SELECT owner_id, MAX_OF(1, COUNT(*) / 13000) AS count
FROM `{EVENT_LOG_TABLE}`
WHERE flag_virtual == 0 AND load == 1 AND ignore == ""
GROUP BY owner_id);
COMMIT;

INSERT INTO `{SAMPLES_TABLE}`
SELECT
    log.owner_id as oid,
    groups.group_id as g,
    log.eff_uid as uid,
    log.adf_browser_id as bro,
    log.ya_device_type as dev,
    log.`timestamp` as ts,
    log.krypta_age_value as age,
    log.krypta_sex_value as sex,
    log.krypta_revenue_value as revenue,
    log.adf_os_id as os,
    log.place_id as p,
    log.client_time as client_time,
    log.ya_uid as ya_uid,
    log.ip as ip,
    $parse_referrer(log.referrer) as ref,
    $parse_owner_criteria(log._rest) as oc,
    log.targeting_keywords as targeting_keywords,
    log.dimension_height as dimension_height,
    log.dimension_width as dimension_width,
    log.position_on_page as position_on_page,
    log.ya_geo_id as ya_geo_id,
    $get_page_id(log.rsya_block_id) as rsya_page_id,
    $get_imp_id(log.rsya_block_id) as rsya_imp_id,
    if($is_from_nanpu(_json_headers_parsed), $preferable_width(_request_uri_parsed), 0) as preferable_width,
    if($is_from_nanpu(_json_headers_parsed), $preferable_height(_request_uri_parsed), 0) as preferable_height
FROM `{EVENT_LOG_TABLE}` as log
JOIN `{OWNER_GROUPS_TABLE}` as groups
ON log.owner_id = groups.owner_id
INNER JOIN `{ACCESS_LOG_TABLE}` as access
on log.request_id = access.request_id
WHERE
    log.flag_virtual == 0 AND
    log.load == 1 AND
    log.ignore == "" AND
    log.owner_id != 0 AND
    (
        (log.eff_uid != 0 AND log.eff_uid % groups.count == groups.group_id)
        OR
        (log.eff_uid == 0 AND RandomNumber(log.eff_uid) % groups.count == groups.group_id)
    )
ORDER BY oid, g, ts;
COMMIT;

INSERT INTO `{DMP_TABLE}`
SELECT UniqID as ya_uid, $merge_ya_audience_with_dmps(Segments, Dmps) as dmp
FROM `{PROFILES_TABLE}` AS PROFILES
JOIN (SELECT DISTINCT ya_uid FROM `{SAMPLES_TABLE}`) AS SAMPLES
ON PROFILES.UniqID == SAMPLES.ya_uid;
