from abc import ABCMeta, abstractmethod


class AmacsAdapterInterface(object):
    __metaclass__ = ABCMeta

    @abstractmethod
    def get_engine_executable_path(self):
        pass

    @abstractmethod
    def get_configuration_path(self):
        pass

    @abstractmethod
    def get_atlas_binary_path(self):
        pass

    @abstractmethod
    def get_cache_daemon_stub_path(self):
        pass

    @abstractmethod
    def get_cache_daemon_executable_path(self):
        pass

    @abstractmethod
    def get_cache_daemon_key_headers(self):
        pass

    @abstractmethod
    def get_shoot_logs_uploader_path(self):
        pass
