from sandbox import sdk2
from sandbox.projects.resource_types import CACHE_DAEMON

from sandbox.projects.yabs.qa.adapter_base.sandbox import SandboxAdapterBase

from sandbox.projects.adfox.qa.modules.amacs_module import AmacsModule
from sandbox.projects.adfox.qa.modules.amacs_module.adapters.interface import AmacsAdapterInterface
from sandbox.projects.adfox.qa.modules.amacs_module.adapters.sandbox.parameters import AmacsParameters, \
    generate_parameters_class


class AmacsSandboxAdapter(AmacsAdapterInterface, SandboxAdapterBase):
    def __init__(self, parameters, task_instance):
        SandboxAdapterBase.__init__(self, parameters, task_instance)

    def get_engine_executable_path(self):
        return self.sync_resource(self.parameters.executable)

    def get_configuration_path(self):
        return self.sync_resource(self.parameters.configuration)

    def get_atlas_binary_path(self):
        return self.sync_resource(self.parameters.atlas_binary)

    def get_cache_daemon_stub_path(self):
        return self.sync_resource(self.parameters.cache_daemon_stub_resource)

    def get_cache_daemon_executable_path(self):
        cache_daemon_executable_res_id = self.parameters.cache_daemon_stub_resource.cache_daemon_res_id
        return self.sync_resource(sdk2.Resource.find(CACHE_DAEMON, id=cache_daemon_executable_res_id).first())

    def get_cache_daemon_key_headers(self):
        return self.parameters.cache_daemon_stub_resource.key_header

    def get_shoot_logs_uploader_path(self):
        return self.sync_resource(self.parameters.shoot_logs_uploader)

    @staticmethod
    def get_init_parameters_class(prefix=None):
        return AmacsParameters if not prefix else generate_parameters_class(prefix)

    def create_module(self):
        return AmacsModule(self)
