from sandbox import sdk2

from sandbox.projects.adfox.qa.resource_types import AdfoxShmYtLogsUploader
from sandbox.projects.adfox.resource_types import AdfoxEngineBinaryLayer, AdfoxAtlasCacheFile, \
    AdfoxEngineConfigurationLayer
from sandbox.projects.yabs.qa.resource_types import YABS_SERVER_CACHE_DAEMON_STUB_DATA


class AmacsParameters(sdk2.Task.Parameters):
    # resources
    executable = sdk2.parameters.Resource(
        'Resource with engine executable',
        resource_type=AdfoxEngineBinaryLayer,
        required=True)
    configuration = sdk2.parameters.Resource(
        "Engine configuration resource",
        resource_type=AdfoxEngineConfigurationLayer,
        required=True)
    atlas_binary = sdk2.parameters.Resource(
        'Resource with atlas cache binary file',
        resource_type=AdfoxAtlasCacheFile,
        required=True)
    cache_daemon_stub_resource = sdk2.parameters.Resource(
        'Resource with cache_daemon stub data',
        resource_type=YABS_SERVER_CACHE_DAEMON_STUB_DATA,
        required=True)
    shoot_logs_uploader = sdk2.parameters.LastReleasedResource(
        "Shoot task logs YT uploader (last released used by default)",
        resource_type=AdfoxShmYtLogsUploader,
        required=True)

    # required settings
    tmpfs_size = sdk2.parameters.Integer('Tmpfs size', default_value=0)


def generate_parameters_class(parameters_prefix):
    def prefixed_dict(**kwargs):
        return {'{}_{}'.format(parameters_prefix, k): v for k, v in kwargs.items()}

    parameters_dictionary = prefixed_dict(
        executable=sdk2.parameters.Resource(
            'Resource with engine executable',
            resource_type=AdfoxEngineBinaryLayer,
            required=True),
        configuration=sdk2.parameters.Resource(
            "Engine configuration resource",
            resource_type=AdfoxEngineConfigurationLayer,
            required=True),
        atlas_binary=sdk2.parameters.Resource(
            'Resource with atlas cache binary file',
            resource_type=AdfoxAtlasCacheFile,
            required=True),
        cache_daemon_stub_resource=sdk2.parameters.Resource(
            'Resource with cache_daemon stub data',
            resource_type=YABS_SERVER_CACHE_DAEMON_STUB_DATA,
            required=True),
        shoot_logs_uploader=sdk2.parameters.LastReleasedResource(
            "Shoot task logs YT uploader (last released used by default)",
            resource_type=AdfoxShmYtLogsUploader,
            required=True)
    )
    parameters_dictionary['__names__'] = tuple(k for k in parameters_dictionary.keys())
    return type('Parameters', (sdk2.Task.Parameters,), parameters_dictionary)
