import os
import tarfile
import uuid

from sandbox.projects.yabs.qa.adapter_base.sandbox import SandboxAdapterBase
from sandbox.projects.yabs.qa.yt_uploader_module import ShootResultsYtUploaderModule
from sandbox.projects.yabs.qa.yt_uploader_module.adapters.interface import \
    ShootResultsYtUploaderAdapterInterface

from parameters import ShootResultsYtUploaderAdfoxParameters
from sandbox.projects.adfox.qa.utils.constants import YAV_ROBOT_QA_ADFOX_YT_TOKEN
from sandbox.projects.adfox.qa.utils.secrets import get_yav_secret

YT_UPLOADER_EXECUTABLE_NAME = 'yt_uploader'


class ShootResultsYtUploaderAdfoxSandboxAdapter(ShootResultsYtUploaderAdapterInterface, SandboxAdapterBase):
    def __init__(self, parameters, task_instance):
        SandboxAdapterBase.__init__(self, parameters, task_instance)

    def get_yt_uploader_executable_path(self):
        resource_path = self.sync_resource(self.parameters.yt_uploader_resource)
        with tarfile.open(resource_path) as tar:
            tar.extractall(self.get_work_dir())
        return os.path.join(self.get_work_dir(), YT_UPLOADER_EXECUTABLE_NAME)

    def get_yt_token(self):
        return get_yav_secret(YAV_ROBOT_QA_ADFOX_YT_TOKEN)['YT_TOKEN']

    @staticmethod
    def get_work_dir():
        return os.getcwd()

    def get_yt_table_path(self):
        if self.parameters.yt_table_prefix:
            return self.parameters.yt_table_prefix + (
                '/' if not self.parameters.yt_table_prefix.endswith('/') else '') + str(uuid.uuid4())
        else:
            return None

    def get_yt_ttl_days(self):
        return self.parameters.yt_ttl_days

    @staticmethod
    def get_init_parameters_class():
        return ShootResultsYtUploaderAdfoxParameters

    def create_module(self):
        return ShootResultsYtUploaderModule(self)
