import os
import signal
import uuid

from sandbox import sdk2
from sandbox.projects.yabs.qa.module_base import ModuleBase
from sandbox.projects.adfox.qa.resource_types import AdfoxPcapFile
from sandbox.sdk2.helpers import ProcessLog, subprocess


class TcpdumpModule(ModuleBase):
    def __init__(self, adapter):
        super(TcpdumpModule, self).__init__(adapter)
        self.port_to_trace = None

    def trace_port(self, port_to_trace):
        self.port_to_trace = port_to_trace
        return self

    def __enter__(self):
        self._log = ProcessLog(logger='tcpdump_log')
        self._log.__enter__()
        self.pcap_file = str(uuid.uuid4())
        self._process = subprocess.Popen(
            ['tcpdump',
             '-i', 'any',
             '-A', '-vv',
             '-w', self.pcap_file,
             'port {0}'.format(self.port_to_trace),
             '-B', '65536'],
            stdout=self._log.stdout,
            stderr=self._log.stderr)

    def __exit__(self, *args):
        self._process.send_signal(signal.SIGINT)
        os.wait4(self._process.pid, os.WUNTRACED)
        self._log.__exit__(*args)
        created_resource = AdfoxPcapFile(self.adapter.task_instance, 'pcap file', self.pcap_file)
        sdk2.ResourceData(created_resource).ready()
