from sandbox.projects.common.build.YaPackage import YaPackageResource

from sandbox import sdk2
from sandbox.projects.adfox.resource_types import RELEASERS as ADFOX_RELEASERS


# executable resources #

class AdfoxBulletsBuilder(YaPackageResource):
    """ builds prepared_log from collected_log """
    ttl = 365
    releasers = ADFOX_RELEASERS


class AdfoxShmYtResultsUploader(YaPackageResource):
    """ uploads shoot logs to yt """
    ttl = 365
    releasers = ADFOX_RELEASERS


class AdfoxShmYtLogsUploader(YaPackageResource):
    """ uploads engine logs to yt """
    ttl = 365
    releasers = ADFOX_RELEASERS


class AdfoxShmShootValidator(YaPackageResource):
    """ compares sandbox shoot with production logs """
    ttl = 365
    releasers = ADFOX_RELEASERS


class AdfoxShmShootComparator(YaPackageResource):
    """ compares 2 sandbox shoots """
    ttl = 365
    releasers = ADFOX_RELEASERS


# spec resources #

class AdfoxShmAdfoxSpec(sdk2.Resource):
    ttl = 365
    auto_backup = True

    testenv_switch_trigger_adfox = sdk2.parameters.String('testenv_switch_trigger_adfox')


# output resources #

class AdfoxShmFlameGraphResource(sdk2.Resource):
    """ perf flame graph from performance shoot """
    ttl = 365


class AdfoxPcapFile(sdk2.Resource):
    """ tcpdump PCAP file from functional shoot """
    ttl = 365


# deprecared
# resources for functional tests
class AdfoxQaDataFile(sdk2.Resource):
    """
    SQLite database with QA Dataholder pickles
    """
    auto_backup = True
    test_name = sdk2.parameters.String('test_name', required=True)
