from sandbox import sdk2
from sandbox.sandboxsdk import environments

from sandbox.projects.adfox.qa.utils import constants
from sandbox.projects.adfox.qa.utils.secrets import get_yav_secret


class AdfoxServerBase(sdk2.Task):
    name = 'ADFOX_SERVER_BASE'

    class Requirements(sdk2.Task.Requirements):
        environments = (
            environments.PipEnvironment('requests'),
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('psycopg2-binary', '2.7.7'),
        )

    _yt_initialised = False

    @property
    def yt(self):
        import yt.wrapper as yt

        if not self._yt_initialised:
            yt.config['proxy']['url'] = constants.YT_PROXY
            yt.config['token'] = get_yav_secret(constants.YAV_ROBOT_QA_ADFOX_YT_TOKEN)['YT_TOKEN']
            self._yt_initialised = True

        return yt

    def on_execute(self):
        pass
