from sandbox import sdk2

from sandbox.projects.yabs.qa.ammo_module.requestlog.adapters.general.sandbox import \
    AmmoRequestlogModuleGeneralSandboxAdapter as AmmoRequestlogModuleAdapter
from sandbox.projects.yabs.qa.dolbilo_module.simple.adapters.sandbox import \
    DolbiloModuleSandboxAdapter as DolbiloModuleAdapter

from sandbox.projects.adfox.qa.modules.amacs_module.adapters.sandbox import AmacsSandboxAdapter
from sandbox.projects.adfox.qa.modules.shoot_results_uploader.adapters.sandbox import \
    ShootResultsYtUploaderAdfoxSandboxAdapter as ShootResultsYtUploaderAdapter
from sandbox.projects.adfox.qa.utils import constants
from sandbox.projects.adfox.qa.tasks.AdfoxServerBase import AdfoxServerBase

# Base class for shoot tasks
# includes Requirements, basic Parameters and Context

SHOOT_CONTAINER = 1442959811


class AdfoxServerBaseShoot(AdfoxServerBase):
    name = 'ADFOX_SERVER_BASE_SHOOT'

    class Requirements(AdfoxServerBase.Requirements):
        privileged = True  # for root
        cores = 4
        disk_space = 40 * 1024  # 40 GB
        ram = 16 * 1024  # 16 GB

    class Parameters(AdfoxServerBase.Parameters):
        _container = sdk2.parameters.Container(
            'lxc container for adfox shoot tasks',
            default_value=SHOOT_CONTAINER,
            platform='linux_ubuntu_16.04_xenial',
            required=True,
        )

        with sdk2.parameters.Group('Engine settings') as engine_settings:
            engine_parameters = AmacsSandboxAdapter.get_init_parameters_class()()

        with sdk2.parameters.Group('Ammo module settings') as ammo_module_setting:
            ammo_parameters = AmmoRequestlogModuleAdapter.get_init_parameters_class()()

        with sdk2.parameters.Group('Shoot module settings') as shoot_module_settings:
            dolbilo_parameters = DolbiloModuleAdapter.get_init_parameters_class()()

        with sdk2.parameters.Group('Shoot results uploader settings') as shoot_results_uploader_settings:
            shoot_results_uploader_parameters = ShootResultsYtUploaderAdapter.get_init_parameters_class()()

    class Context(AdfoxServerBase.Context):
        # task details
        result_root_directory = None
        testenv_database = None

    def prepare_dir(self):
        is_auto_run = self.Context.testenv_database == constants.MAIN_TE_DATABASE
        self.Context.result_root_directory = self.yt.ypath_join(constants.YT_REPORTS_DIR, str(self.id))
        self.yt.create('map_node', self.Context.result_root_directory, ignore_existing=False, force=False)
        self.yt.set_attribute(self.Context.result_root_directory, constants.YT_REPORT_IS_AUTO_RUN_ATTR, is_auto_run)

    def on_execute(self):
        self.prepare_dir()
        self.execute()

    def execute(self):
        """
        Performs shoot
        Should be redefined in subclass
        :return:
        """
        pass
