import datetime as dt

SELECT_OLD_REPORTS = """
    SELECT
        id,
        table_name
    FROM shm.diff_tables
    WHERE
        (created < TIMESTAMP '{auto_ttl}' AND is_review = FALSE) OR
        (created < TIMESTAMP '{user_ttl}' AND is_review = TRUE)
"""

DROP_OLD_REPORT_TABLE = """
    DROP TABLE IF EXISTS shm."{table_name}"
"""

DELETE_OLD_REPORTS_RECORDS = """
    DELETE FROM shm.diff_tables WHERE id IN ({ids_to_drop})
"""


def select_old_reports(cursor, auto_ttl, user_ttl):
    def get_ttl(days):
        return (dt.datetime.now() - dt.timedelta(days=days)).strftime('%Y-%m-%d %H:%M:%S')

    cursor.execute(SELECT_OLD_REPORTS.format(auto_ttl=get_ttl(auto_ttl),
                                             user_ttl=get_ttl(user_ttl)))
    return [{'id': rec[0], 'table': rec[1]} for rec in cursor.fetchall()]


def drop_old_report_table(cursor, table_name):
    cursor.execute(DROP_OLD_REPORT_TABLE.format(table_name=table_name))


def delete_old_reports_records(cursor, ids_to_drop):
    if ids_to_drop:
        cursor.execute(DELETE_OLD_REPORTS_RECORDS.format(ids_to_drop=', '.join([str(el) for el in ids_to_drop])))
