from sandbox.projects.adfox.qa.modules.amacs_module.adapters.sandbox import AmacsSandboxAdapter
from sandbox.projects.adfox.qa.modules.tcpdump_module.adapters.sandbox import TcpdumpSandboxAdapter
from sandbox.projects.adfox.qa.modules.shoot_results_uploader.adapters.sandbox import \
    ShootResultsYtUploaderAdfoxSandboxAdapter as ShootResultsYtUploaderAdapter
from sandbox.projects.adfox.qa.tasks.AdfoxServerBaseShoot import AdfoxServerBaseShoot

from sandbox.projects.yabs.qa.ammo_module.requestlog.adapters.general.sandbox import \
    AmmoRequestlogModuleGeneralSandboxAdapter as AmmoRequestlogModuleAdapter
from sandbox.projects.yabs.qa.dolbilo_module.simple.adapters.sandbox import \
    DolbiloModuleSandboxAdapter as DolbiloModuleAdapter


class AdfoxServerFunctionalShoot(AdfoxServerBaseShoot):
    name = 'ADFOX_SERVER_FUNCTIONAL_SHOOT'

    class Context(AdfoxServerBaseShoot.Context):
        # uploaded shoot results - must be set in subclass!
        result_event_log = None
        result_fraud_event_log = None
        result_fast_fraud_event_log = None
        result_external_requests_log = None
        result_response_log = None

    def upload_response_log(self, shoot_data_path):
        response_log_uploader = ShootResultsYtUploaderAdapter(
            self.Parameters.shoot_results_uploader_parameters, self).create_module()

        self.Context.result_response_log = self.yt.ypath_join(self.Context.result_root_directory, 'shoot')
        response_log_uploader.upload_results(results_path=shoot_data_path,
                                             yt_table_path=self.Context.result_response_log)

    def execute(self):
        engine_service = AmacsSandboxAdapter(self.Parameters.engine_parameters, self).create_module()
        ammo_module = AmmoRequestlogModuleAdapter(self.Parameters.ammo_parameters, self).create_module()
        shoot_module = DolbiloModuleAdapter(self.Parameters.dolbilo_parameters, self).create_module()
        tcpdump_module = TcpdumpSandboxAdapter(self.Parameters, self).create_module()

        with engine_service as active_service:
            with tcpdump_module.trace_port(engine_service.get_port()):
                shoot_data_path = shoot_module.shoot(active_service, ammo_module.get_dplan_path())

        engine_service.upload_logs()
        self.upload_response_log(shoot_data_path)
