COLLECTED_LOGS_TEMPLATE = """
$script = @@
import json

def parse_headers(headers_str):
    headers_json = json.loads(headers_str.decode('utf-8', 'ignore'))
    for key, value in headers_json.items():
        headers_json[key] = str(value)
    return headers_json
@@;

$parse_headers = Python3::parse_headers(
    Callable<(String?)->Dict<String,String>>,
    $script
);

$serialized_event_log = (
SELECT
    request_id,
    ToBytes(Yson::SerializeJson(Yson::From(
        {"records" : aggregate_list(ForceRemoveMember(TableRow(), "request_id"))}
    ))) as EventLogRecords
FROM
(
    -- ADFOX-20677
    SELECT
        `request_id`,
        `tasks.type`,
        `tasks.errcode`,
        `ya_uid`
    FROM #EVENT_LOG#
)
GROUP BY request_id
);

INSERT INTO #COLLECTED_LOG#
SELECT
    -- casted to string so it will be sorted the same way as "prepared_logs"
    CAST(ext.request_id AS String) AS RequestID,
    ext.request_session AS RequestSession,
    ext.random_seed AS RandomSeed,
    ext.`timestamp` AS Unixtime,
    CAST(Yson::SerializeJson(Yson::Parse(ext.data)) AS String) AS ExternalServicesResponses,
    CAST(Yson::SerializeJson(Yson::FromStringDict(AsDict(
        AsTuple("RequestHeaders", CAST (Yson::SerializeJson(Yson::FromStringDict(SetUnion(
            $parse_headers(access.json_headers),
            -- fallbacks
            AsDict(
                AsTuple("host", access.host),
                AsTuple("x-forwarded-proto", access.proto),
            ),
            ($k, $a, $b) -> { RETURN $a ?? $b ?? "" }
        ))) AS String) ?? ""),
        AsTuple("RequestURI", access.request_uri ?? ""),
        AsTuple("RequestMethod", access.request_method ?? ""),
        AsTuple("ServerProtocol", access.server_protocol ?? ""),
        AsTuple("RequestBody", access.request_body ?? ""),
        AsTuple("ProcessType", access.process_type ?? ""),
        -- don't use upstream_status because it can contain info about redirects
        AsTuple("HttpStatus", CAST(access.status AS String) ?? "")
    ))) AS String) AS RequestToEngine,
    event_log.EventLogRecords as EventLogRecords
FROM #EXTERNAL_REQUESTS_LOG# AS ext
INNER JOIN #ACCESS_LOG# AS access
ON ext.request_id = access.request_id
LEFT JOIN $serialized_event_log AS event_log
ON ext.request_id = event_log.request_id
ORDER BY RequestID ASC
"""

FILTER_EVENT_LOG_TEMPLATE = """
INSERT INTO #FILTERED_EVENT_LOG#
SELECT event_log.*
FROM (
    SELECT DISTINCT GraphID FROM #PREPARED_LOGS#
) AS prepared_log
INNER JOIN #EVENT_LOG# AS event_log
ON event_log.request_id = CAST(prepared_log.GraphID AS Uint64)
"""
